/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.IntConsumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public final class Scheduler {
    private static Plugin instance;

    public static BukkitTask sync(Runnable run) {
        return Bukkit.getScheduler().runTask(instance, run);
    }

    public static BukkitTask async(Runnable run) {
        return Bukkit.getScheduler().runTaskAsynchronously(instance, run);
    }

    public static BukkitTask later(Runnable run, long delay) {
        return Bukkit.getScheduler().runTaskLater(instance, run, delay);
    }

    public static BukkitTask laterAsync(Runnable run, long delay) {
        return Bukkit.getScheduler().runTaskLaterAsynchronously(instance, run, delay);
    }

    public static BukkitTask repeat(Runnable run, long delay, long period) {
        return Bukkit.getScheduler().runTaskTimer(instance, run, delay, period);
    }

    public static BukkitTask repeatAsync(Runnable run, long delay, long period) {
        return Bukkit.getScheduler().runTaskTimerAsynchronously(instance, run, delay, period);
    }

    public static BukkitTask repeatUntil(Runnable run, long delay, long period, BooleanSupplier until) {
        return Scheduler.repeatWhile(run, delay, period, () -> !until.getAsBoolean());
    }

    public static BukkitTask repeatAsyncUntil(Runnable run, long delay, long period, BooleanSupplier until) {
        return Scheduler.repeatAsyncWhile(run, delay, period, () -> !until.getAsBoolean());
    }

    public static BukkitTask repeatWhile(Runnable run, long delay, long period, BooleanSupplier condition) {
        Task task = new Task(run, condition);
        BukkitTask bukkitTask = Scheduler.repeat(task, delay, period);
        task.setTask(bukkitTask);
        return bukkitTask;
    }

    public static BukkitTask repeatAsyncWhile(Runnable run, long delay, long period, BooleanSupplier condition) {
        Task task = new Task(run, condition);
        BukkitTask bukkitTask = Scheduler.repeatAsync(task, delay, period);
        task.setTask(bukkitTask);
        return bukkitTask;
    }

    public static BukkitTask repeatFor(IntConsumer consumer, long delay, long period, int count) {
        IncrementTask task = new IncrementTask(consumer, count);
        BukkitTask bukkitTask = Scheduler.repeat(task, delay, period);
        task.setTask(bukkitTask);
        return bukkitTask;
    }

    public static BukkitTask repeatAsyncFor(IntConsumer consumer, long delay, long period, int count) {
        IncrementTask task = new IncrementTask(consumer, count);
        BukkitTask bukkitTask = Scheduler.repeatAsync(task, delay, period);
        task.setTask(bukkitTask);
        return bukkitTask;
    }

    public static BukkitTask repeatFor(Runnable run, long delay, long period, long duration, TimeUnit unit) {
        long until = unit.toMillis(duration);
        Task task = new Task(run, () -> System.currentTimeMillis() < until);
        BukkitTask bukkitTask = Scheduler.repeat(task, delay, period);
        task.setTask(bukkitTask);
        return bukkitTask;
    }

    public static BukkitTask repeatAsyncFor(Runnable run, long delay, long period, long duration, TimeUnit unit) {
        long until = unit.toMillis(duration);
        Task task = new Task(run, () -> System.currentTimeMillis() < until);
        BukkitTask bukkitTask = Scheduler.repeatAsync(task, delay, period);
        task.setTask(bukkitTask);
        return bukkitTask;
    }

    private static class Task
    implements Runnable {
        BukkitTask task;
        boolean cancelled;
        private final Runnable runnable;
        private final BooleanSupplier condition;

        Task(Runnable runnable, BooleanSupplier condition) {
            this.runnable = runnable;
            this.condition = condition;
        }

        final void setTask(BukkitTask task) {
            this.task = task;
        }

        @Override
        public void run() {
            if (this.cancelled) {
                if (this.task != null) {
                    this.task.cancel();
                }
                return;
            }
            if (this.condition.getAsBoolean()) {
                this.runnable.run();
            } else if (this.task != null) {
                this.task.cancel();
            } else {
                this.cancelled = true;
            }
        }
    }

    private static class IncrementTask
    extends Task
    implements Runnable {
        private final int maxCount;
        private final IntConsumer consumer;
        private final AtomicInteger count = new AtomicInteger();

        IncrementTask(IntConsumer consumer, int maxCount) {
            super(null, null);
            this.maxCount = maxCount;
            this.consumer = consumer;
        }

        @Override
        public void run() {
            if (this.cancelled) {
                if (this.task != null) {
                    this.task.cancel();
                }
                return;
            }
            int count = this.count.getAndIncrement();
            if (count < this.maxCount) {
                this.consumer.accept(count);
            } else if (this.task != null) {
                this.task.cancel();
            } else {
                this.cancelled = true;
            }
        }
    }
}

